#202506_08[MHP]: Main diff. of v9 vs v8ext3 is considering the case when lat0 > lat1 and dlat > 0 (case of Iscale IsUG files). Then, instead of aborting, the "-" should be automatically applied to dlat.
#20101122[MHP]: Main diff. of v6 regarding to v5 is the generation of two additional files, "dcbs.satellites.mutd" and "dcbs.stations.murd", in MONITOR format of corresponding UPC ionospheric external product.
#20080121: Difference regarding to ionex2plotlst4 (and older versions): bug fixed in length of comparison string to grep "LAT/LON1/LON2/DLON/H" (this bug was discovered working with IGGG ionex files)
BEGIN{
      itecmap=0
      digits_per_value=5
      line_length=80 
      values_per_line=int(line_length/digits_per_value)
      print "digits_per_value,line_length,values_per_line=",digits_per_value,line_length,values_per_line > "temp.log"
      tec_instead_of_rms=1
      exponent=-1
      n_mandatory_field = 0
      if(length(lonsel0)==0 || length(lonsel1)==0){
	      lonsel0=-180
	      lonsel1=180
      }
      if(length(latsel0)==0 || length(latsel1)==0){
	      latsel0=-90
	      latsel1=90
      }
}
#{
{

      if(substr($0,61,18)=="EPOCH OF FIRST MAP"){
                                                 year0=$1
                                                 month0=$2
                                                 day0=$3
                                                 hour0=$4
                                                 minute0=$5
                                                 seconds0=$6
						 n_mandatory_field++
                                                 print year0,month0,day0,hour0,minute0,seconds0 > "t_lat_lon.info"
                                                }

      if(substr($0,61,17)=="EPOCH OF LAST MAP"){
                                                 year1=$1
                                                 month1=$2
                                                 day1=$3
                                                 hour1=$4
                                                 minute1=$5
                                                 seconds1=$6
						 n_mandatory_field++
                                                 #print year1,month1,day1,hour1,minute1,seconds1 > "t_lat_lon.info"
                                                }


      if(substr($0,61,8)=="INTERVAL"){
                                      interval=$1
			       	      n_mandatory_field++
                                      #print interval > "t_lat_lon.info"
                                     }

      if(substr($0,61,17)=="# OF MAPS IN FILE"){
                                                nmaps=$1
						if ( nmaps > 999 ) {
							print "ERROR @ ionex2plotlst_ext3 : nmaps = "nmaps " > 999"
							print " (Please consider the usage of version ionex2plotlst_ext5 or six... or similar)"
							exit -2
						}
						n_mandatory_field++
                                                #print nmaps > "t_lat_lon.info"
                                               }

      if(substr($0,61,11)=="BASE RADIUS"){
                                            bradius=$1 
				    	    n_mandatory_field++
                                            #print bradius > "t_lat_lon.info"
                                           }

      if(substr($0,61,18)=="HGT1 / HGT2 / DHGT"){
                                            height0=$1   
                                            height1=$2
                                            dheight=$3
					    n_mandatory_field++	
					    if(height0==height1){
						    h=height0
					    }
					    else
					    {
						    print "Execution aborted (height0 != height1 is not supported in this version of ionex_2_time_lon_lat_h_val_valStd.v0.awk"
						    exit
					    }
                                            #print height0,height1,dheight > "t_lat_lon.info"
                                           }

      if(substr($0,61,13)=="MAP DIMENSION"){
                                            mapdim=$1
				            n_mandatory_field++
                                            #print mapdim > "t_lat_lon.info"
                                           }

      if(substr($0,61,18)=="LAT1 / LAT2 / DLAT"){
                                                 lat0=+substr($0,4,5)
                                                 lat1=+substr($0,10,5)
                                                 dlat=+substr($0,16,5)
						 if(lat0 > lat1 && dlat > 0){
							 	dlat=-dlat
								print "WARNING dlat has been multiplied by -1 because of lat0 = "lat0" > lat1 = "lat1" and dlat = "dlat" > 0" >> "temp.log"
							}
						 n_mandatory_field++
                                                 #print lat0,lat1,dlat > "t_lat_lon.info"
                                                } 
      if(substr($0,61,18)=="LON1 / LON2 / DLON"){
                                                 lon00=+substr($0,3,6)
                                                 lon11=+substr($0,9,6)
                                                 dlon0=+substr($0,15,6)
						 n_mandatory_field++
                                                 #print lon00,lon11,dlon0 > "t_lat_lon.info"

                                                } 

      if(substr($0,61,8)=="EXPONENT"){
                                                 exponent=$1
                                                 #print exponent > "t_lat_lon.info"

                                                }

      if(substr($0,61,16)=="PRN / BIAS / RMS"){
                                                 print substr($0,1,26) > "dcbs.satellites"

						if(substr($0,4,1)==" " || substr($0,4,1)=="G"){
							print substr($0,5,2),substr($0,8,9),substr($0,18,9) > "dcbs.satellites.gps"
							printf "%s %2d %8.3f %8.3f\n","G",substr($0,5,2),substr($0,8,9),substr($0,18,9) > "dcbs.satellites.gps"
							}
						else
							{

							if(substr($0,4,1)=="R"){
								print substr($0,5,2),substr($0,8,9),substr($0,18,9) > "dcbs.satellites.glonass"
								}
							else
								{

								print "ERROR: unknown kind of satellite: "substr($0,4,1)
								print "EXECUTION ABORTED"
								exit -2

								}

							}

                                                }

      if(substr($0,61,20)=="STATION / BIAS / RMS"){

                                                print substr($0,1,46) > "dcbs.stations"


						if(substr($0,4,1)==" " || substr($0,4,1)=="G"){

							print tolower(substr($0,7,4)),substr($0,28,9),substr($0,38,9) > "dcbs.stations.gps"

							}
						else
							{

							if(substr($0,4,1)=="R"){
								#print substr($0,5,2),substr($0,8,9),substr($0,18,9) > "dcbs.satellites.glonass"
								print tolower(substr($0,7,4)),substr($0,28,9),substr($0,38,9) > "dcbs.stations.glonass"
								}
							else
								{

								print "ERROR: unknown kind of station: "substr($0,4,1)
								print "EXECUTION ABORTED"
								exit -2

								}

							}
                                                }

      if(substr($0,61,13)=="END OF HEADER"){

		if ( n_mandatory_field == 9 ) {
			print year0,month0,day0,hour0,minute0,seconds0 > "t_lat_lon.info"
			print year1,month1,day1,hour1,minute1,seconds1 > "t_lat_lon.info"
			print interval > "t_lat_lon.info"
			print nmaps > "t_lat_lon.info"
			print bradius > "t_lat_lon.info"
			print mapdim > "t_lat_lon.info"
			print height0,height1,dheight > "t_lat_lon.info"
			print lat0,lat1,dlat > "t_lat_lon.info"
			print lon00,lon11,dlon0 > "t_lat_lon.info"
			print exponent > "t_lat_lon.info"
		}
		else
		{
			print "ERROR @ ionex2plotlst*.awk : n_mandatory_field = "n_mandatory_field" != 9"
			print "ERROR @ ionex2plotlst*.awk : n_mandatory_field = "n_mandatory_field" != 9" > "t_lat_lon.info"
			exit -1
		}

	}

      #if(substr($0,61,16)=="START OF TEC MAP"){
      if(substr($0,61,16)=="START OF TEC MAP" || substr($0,61,17)=="START OF IsUG MAP"){

					#	print "PROVISIONAL EXIT"
					#	exit -1

                                               itecmap=+substr($0,2,5)
                                               ##itmf=itecmap
                                               ##if(itecmap<10)itmf="0"itmf
                                               ##if(itecmap<100)itmf="0"itmf
#
                                               #itmf=sprintf("%05d",itecmap)
#
                                               itmf=sprintf("%03d",itecmap)
#
                                               ilat=0
                                               tec_instead_of_rms=1 
                                              }

      if(substr($0,61,16)=="START OF RMS MAP"){
                                               itecmap=+substr($0,2,5)
                                               itmf=itecmap
                                               ##if(itecmap<10)itmf="0"itmf
                                               ##if(itecmap<100)itmf="0"itmf
                                               ##itmf=itecmap
#
                                               #itmf=sprintf("%05d",itecmap)
#
                                               itmf=sprintf("%03d",itecmap)
#
                                               ilat=0
                                               tec_instead_of_rms=0
                                              }


      if(substr($0,61,23)=="EPOCH OF CURRENT MAP"){
                                                   year=+substr($0,3,4)
                                                   month=+substr($0,11,2)
                                                   day=+substr($0,17,2)
                                                   hour=+substr($0,23,2)
                                                   minute=+substr($0,29,2)
                                                   seconds=+substr($0,35,6)

#
# Patch to allow extracting from multiday ionex file (the interval and map number is used
# from the stating epoch, to avoid problems with the month changes, etc...)
#
#                                                   time_hours=hour+minute/60+seconds/3600
                                                   time_hours=(interval/3600)*(itmf-1)+hour0+minute0/60+seconds0/3600


                                                   if ( tec_instead_of_rms == 1 ) printf "%5.2f\n",time_hours > "info."itmf
						} 

	##print $0
	##print substr($0,61,20)

      if(substr($0,61,20)=="LAT/LON1/LON2/DLON/H"){
                                                   ilat=ilat+1 

                                                   lat=+substr($0,4,5)
                                                   lon0=+substr($0,9,6)
                                                   lon1=+substr($0,15,6)
                                                   dlon=+substr($0,21,6)
                                                  
                                                   nvalues=1+(lon1-lon0)/dlon
                                                   nlines=int(nvalues*digits_per_value/line_length)+1
                                                   values_to_read_last_line=nvalues-(nlines-1)*values_per_line

                                                   iline=1
                                                   nvalues_read=0
                                                   ivalt=0

							#print "ilat,lat,lon0,lon1,dlon,ivalt=",ilat,lat,lon0,lon1,dlon,ivalt

                                                   while ( iline <= nlines ){

                                                        getline
                                                        if ( iline < nlines ) {
                                                                               values_to_read=values_per_line
                                                                              }
                                                                          else
                                                                              {
                                                                               values_to_read=values_to_read_last_line
                                                                              }

                                                        for(ival=1;ival<=values_to_read;ival++){
                                                                              ivalt=ivalt+1
                                                                              lon=lon0+(ivalt-1)*dlon
                                                                              c0=1+digits_per_value*(ival-1)
                                                                              itec=+substr($0,c0,digits_per_value)
									      tec=itec*(10^exponent)
                                                                              ##printf "%4d %2d %2d %9.6f %6.1f %5.1f %5d %5d\n",year,month,day,time_hours,lon,lat,tec,ivalt
                                                                              if(tec_instead_of_rms==1){
                                                                                                      #printf "%3d %3d %5d %7.2f %6.2f\n",ivalt,ilat,tec,lon,lat > "tec."itmf
										      #ESTOY AQUI (a completar, probar...):
										      			if(lon >= lonsel0 && lon <= lonsel1 && lat >= latsel0 && lat <= latsel1 ){
                                                                                                      		printf "%4d %2d %2d %2d %2d %9.6f %9.6f %7.2f %6.2f %6.1f %5d %8.2f\n",year,month,day,hour,minute,seconds,time_hours,lon,lat,h,itec,tec
													}
												}
											}
#
# Patch to allow extracting from multiday ionex file (the interval and map number is used
# from the stating epoch, to avoid problems with the month changes, etc...)
#
												##################		th,tec,lon,lat > "tec."itmf
                                                                                        ######               }
                                                                                                   #else
                                                                                                   #    {
                                                                                                   #   printf "%3d %3d %5d %7.2f %6.2f\n",ivalt,ilat,tec,lon,lat > "rms."itmf
                                                                                                   #    } 
                                                                                        ######             }

                                                                iline ++ 
                                                                            }

                                                  }


#      print nmaps,lat0,lat1,dlat,lon0,lon1,dlon,itecmap,year,month,day,hour,minute,seconds





}  
